<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BookFavorite extends Model 
{

    protected $table = 'books_favorite';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'book_id', 'department_id');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function book()
    {
        return $this->belongsTo('App\Models\Book', 'book_id');
    }

    public function department()
    {
        return $this->belongsTo('App\Models\FavoriteDepartment', 'department_id');
    }

}